// GcfExtr.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#define CHUNK 256*1024

// The arguments sent to the application
struct SArguments
{
	SArguments() :
		ShowBanner(true),
		ShowUsage(false),
		InputFilename(""),
		OutputDir(""),
		OutputOverwrite(false)
	{
	};

	bool ShowBanner;
	bool ShowUsage;
	std::string InputFilename;
	std::string OutputDir;
	bool OutputOverwrite;
};

// Parse the arguments sent to the program
bool ParseArguments(SArguments& Args, unsigned long Argc, _TCHAR* Argv[])
{
	// Go through each of the arguments sent
	for(unsigned long i=1;i<Argc;)
	{
		std::string Arg(Argv[i++]);
		
		// Check it
		if(Arg=="-b" || Arg=="--no-banner")
		{
			Args.ShowBanner=false;
		}
		else if(Arg=="-o" || Arg=="--output")
		{
			if(i>=Argc)
			{
				return false;
			}
			Args.OutputDir=std::string(Argv[i++]);
		}
		else if(Arg=="-w" || Arg=="--overwrite")
		{
			Args.OutputOverwrite=true;
		}
		else if(Arg=="-n" || Arg=="--no-overwrite")
		{
			Args.OutputOverwrite=false;
		}
		else
		{
			Args.InputFilename=Arg;
		}
	}
	return true;
}

#define DoInflate(Variable, Length) DirStream.avail_out=Length; \
									DirStream.next_out=(Bytef*)Variable; \
									inflate(&DirStream, Z_NO_FLUSH); \
									if(DirStream.avail_out!=0) \
									{ \
										std::cout << "Error: inflate" << std::endl; \
										delete[] CompDir; \
										Input.close(); \
										return 6; \
									}

#define MAX_DEPTH 256
#define MAX_FILENAME 1024

bool MakeDir(const char* DirName)
{
	unsigned long DirTree[MAX_DEPTH];
	unsigned long DirNumber=0;
	long i;
	bool HasEnd=false;
	char CopyDir[MAX_FILENAME];

	strncpy(CopyDir, DirName, MAX_FILENAME);

	for(i=0;i<(long)strlen(CopyDir);i++)
	{
		if(CopyDir[i]=='\\' || CopyDir[i]=='/')
		{
			if(i!=0 || i==(strlen(CopyDir)-1))
			{
				DirTree[DirNumber++]=i;
				if(i==(strlen(CopyDir)-1))
				{
					HasEnd=true;
				}
			}
		}
	}
	if(HasEnd==false)
	{
		DirTree[DirNumber++]=(unsigned long)strlen(CopyDir);
	}
	for(i=0;i<(long)DirNumber-1;i++)
	{
		CopyDir[DirTree[i]]=0;
		if(GetFileAttributes(CopyDir)==INVALID_FILE_ATTRIBUTES || (GetFileAttributes(CopyDir) & FILE_ATTRIBUTE_DIRECTORY)==0)
		{
			if(!CreateDirectory(CopyDir, 0))
			{
				return false;
			}
		}
		CopyDir[DirTree[i]]='\\';
	}
	return true;
}

int _tmain(int Argc, _TCHAR* Argv[])
{
	// Parse the arguments
	SArguments Args;
	if(Argc==1)
	{
		Args.ShowUsage=true;
	}
	bool ArgParse=ParseArguments(Args, Argc, Argv);

	// Display banner
	if(Args.ShowBanner)
	{
		std::cerr << "TikGame's Monopoly GCF Extractor" << std::endl << std::endl;
	}

	// Display usage
	if(Args.ShowUsage)
	{
		std::cout << "Usage: GcfExtr InputFilename [Options]" << std::endl;
		std::cout << std::endl;
		std::cout << "  -o, --output Dir      Specify the output directory" << std::endl;
		std::cout << "  -w, --overwrite       Overwrite existing files" << std::endl;
		std::cout << "  -n, --no-overwrite    Don't overwrite existing files" << std::endl;
	}

	// Check for errors
	if(!ArgParse)
	{
		std::cerr << "The arguments are not valid." << std::endl;
		return 1;
	}

	// Check the arguments
	if(Args.InputFilename=="")
	{
		std::cerr << "Input file not specified." << std::endl;
		return 1;
	}

	// Figure out the right output dir
	if(Args.OutputDir.empty())
	{
		Args.OutputDir=".\\";
	}
	if(Args.OutputDir.at(Args.OutputDir.size()-1)!='\\' || \
		Args.OutputDir.at(Args.OutputDir.size()-1)!='\\')
	{
		Args.OutputDir.append("\\");
	}

	// Open the input stream
	std::ifstream Input;
	Input.open(Args.InputFilename.c_str(), std::ios_base::in | std::ios_base::binary);
	if(!Input.is_open())
	{
		std::cerr << "Unable to open input file '" << Args.InputFilename << "'." << std::endl;
		return 2;
	}

	// Read the directory sizes
	unsigned short UncompDirLength;
	unsigned short CompDirLength;
	Input.read((char*)&UncompDirLength, 2);
	Input.read((char*)&CompDirLength, 2);
	if(!UncompDirLength || !CompDirLength)
	{
		std::cout << "Error: The directory size is 0." << std::endl;
		Input.close();
		return 4;
	}

	// Read the compressed directory
	char* CompDir=new char[CompDirLength];
	Input.read(CompDir, CompDirLength);

	// Read the directory
	z_stream DirStream;
    DirStream.zalloc=Z_NULL;
    DirStream.zfree=Z_NULL;
    DirStream.opaque=Z_NULL;
    DirStream.avail_in=0;
    DirStream.next_in=Z_NULL;
    if(inflateInit(&DirStream)!=Z_OK)
	{
		std::cout << "Error: inflateInit" << std::endl;
		delete[] CompDir;
		Input.close();
		return 5;
	}
	DirStream.avail_in=CompDirLength;
	DirStream.next_in=(Bytef*)CompDir;

	// Read a little
	unsigned char Version;
	unsigned short FileCount;
	DoInflate(&Version, 1);
	DoInflate(&FileCount, 2);

	// Read the directory
	for(unsigned long i=0;i<FileCount;i++)
	{
		// Size of filename
		unsigned char FilenameLen;
		DoInflate(&FilenameLen, 1);
		
		// Filename
		char* Filename=NULL;
		if(FilenameLen>0)
		{
			Filename=new char[FilenameLen+1];
			DoInflate(Filename, FilenameLen);
			Filename[FilenameLen]=NULL;
		}

		// Lengths
		unsigned long CompLen;
		unsigned long UncompLen;
		DoInflate(&CompLen, 4);
		DoInflate(&UncompLen, 4);

		// Open the output file
		std::string OutFilename=Args.OutputDir+std::string(Filename);
		if(Args.OutputOverwrite==false && GetFileAttributes(OutFilename.c_str())!=INVALID_FILE_ATTRIBUTES)
		{
			std::cout << "The file '" << Filename << "' already exists, not overwriting." << std::endl;
			continue;
		}
		std::ofstream Output;
		MakeDir(OutFilename.c_str());
		Output.open(OutFilename.c_str(), std::ios_base::out | std::ios_base::binary | std::ios_base::trunc);
		if(!Output.is_open())
		{
			std::cout << "The file '" << Filename << "' could not be created." << std::endl;
		}

		// Start decompressing
		z_stream Stream;
		Stream.zalloc=Z_NULL;
		Stream.zfree=Z_NULL;
		Stream.opaque=Z_NULL;
		Stream.avail_in=0;
		Stream.next_in=Z_NULL;
		if(inflateInit(&Stream)!=Z_OK)
		{
			std::cout << "Error: inflateInit, for file" << std::endl;
			Output.close();
			delete[] Filename;
			continue;
		}

		// The loop
		std::streamoff End=Input.tellg()+(std::streamoff)CompLen;
		char* ReadInput=new char[CHUNK];
		char* ReadOutput=new char[CHUNK];
		int Return;
		do
		{
			Input.read(ReadInput, min(CHUNK, End-Input.tellg()));
			Stream.avail_in=Input.gcount();
			Stream.next_in=(Bytef*)ReadInput;
			do
			{
				Stream.avail_out=CHUNK;
				Stream.next_out=(Bytef*)ReadOutput;
				Return=inflate(&Stream, Z_NO_FLUSH);
				std::streamsize Have=CHUNK-Stream.avail_out;
				Output.write(ReadOutput, Have);
			} while(Stream.avail_out==0);
		} while(Return!=Z_STREAM_END);

		delete[] ReadInput;
		delete[] ReadOutput;

		// Clean up
		inflateEnd(&Stream);
		Output.close();
		delete[] Filename;
	}

	// Clean up
	inflateEnd(&DirStream);
	delete[] CompDir;
	Input.close();
	return 0;
}

